<?php
namespace Box\Mod\Contabomanager\Controller;
use FOSSBilling\InjectionAwareInterface;
use Pimple\Container;

class Client implements InjectionAwareInterface {
    protected $di;
    public function setDi(Container $di): void { $this->di = $di; }
    public function getDi(): ?Container { return $this->di; }

    public function register($app): void {
        $app->get('/contabomanager', 'get_index', [], get_class($this));
        $app->get('/contabomanager/action/:id/:type', 'get_action', ['id' => '[a-z0-9-]+', 'type' => '[a-z]+'], get_class($this));
    }

    public function get_index($app) {
        $client = $this->di['loggedin_client'];
        
        // Use the exact table structure from your mysql output
        $stmt = $this->di['pdo']->prepare("SELECT instance_id FROM mod_contabomanager_instances WHERE client_id = ?");
        $stmt->execute([$client->id]);
        $assigned_ids = $stmt->fetchAll(\PDO::FETCH_COLUMN);

        $clientServers = [];
        if (!empty($assigned_ids)) {
            require_once __DIR__ . '/../Service.php';
            $service = new \Box\Mod\Contabomanager\Service();
            $service->setDi($this->di);
            
            $all_servers = $service->getInstances();
            foreach($all_servers as $s) {
                if (in_array($s['instanceId'], $assigned_ids)) {
                    $clientServers[] = $s;
                }
            }
        }
        return $app->render('mod_contabomanager_index', ['servers' => $clientServers]);
    }

    public function get_action($app, $id, $type) {
        $client = $this->di['loggedin_client'];
        $stmt = $this->di['pdo']->prepare("SELECT 1 FROM mod_contabomanager_instances WHERE client_id = ? AND instance_id = ?");
        $stmt->execute([$client->id, $id]);
        if (!$stmt->fetchColumn()) {
            throw new \Exception('Access Denied');
        }
        require_once __DIR__ . '/../Service.php';
        $service = new \Box\Mod\Contabomanager\Service();
        $service->setDi($this->di);
        $service->postAction($id, $type);
        header("Location: " . $this->di['url']->link('contabomanager'));
        exit;
    }
}
