<?php
namespace Box\Mod\Contabomanager\Controller;

use FOSSBilling\InjectionAwareInterface;
use Pimple\Container;

class Admin implements InjectionAwareInterface
{
    protected $di;

    public function setDi(Container $di): void { $this->di = $di; }
    public function getDi(): ?Container { return $this->di; }

    public function register($app)
    {
        $app->get('/contabomanager', 'get_index', [], get_class($this));
        $app->post('/contabomanager/save', 'post_save', [], get_class($this));
    }

    public function get_index($app)
    {
        $s = $this->di['db']->findOne('mod_contabomanager_settings', 'id = 1');
        return $app->render('mod_contabomanager_index', ['settings' => $s]);
    }

    public function post_save($app)
    {
        $data = $_POST;
        $s = $this->di['db']->load('mod_contabomanager_settings', 1);
        
        $s->client_id = $data['client_id'] ?? '';
        $s->client_secret = $data['client_secret'] ?? '';
        $s->api_username = $data['api_username'] ?? '';
        $s->api_password = $data['api_password'] ?? '';
        $s->updated_at = date('Y-m-d H:i:s');
        
        $this->di['db']->store($s);
        
        // Fixed redirect to stay within the admin panel properly
        header('Location: ' . $this->di['url']->adminLink('contabomanager'));
        exit;
    }
}
