<?php declare(strict_types=1);

namespace PrinsFrank\Standards\Country\Groups;

use PrinsFrank\Standards\Country\CountryAlpha2;

/**
 * @source https://www.wto.org/english/thewto_e/whatis_e/tif_e/org6_e.htm
 *
 * @updated-by \PrinsFrank\Standards\Dev\DataSource\Mapping\WorldTradeOrganizationMapping
 */
class WorldTradeOrganization implements GroupInterface {
    /** @return list<CountryAlpha2> */
    public static function allAlpha2(): array {
        return [
            CountryAlpha2::Afghanistan,
            CountryAlpha2::Albania,
            CountryAlpha2::Angola,
            CountryAlpha2::Antigua_and_Barbuda,
            CountryAlpha2::Argentina,
            CountryAlpha2::Armenia,
            CountryAlpha2::Australia,
            CountryAlpha2::Austria,
            CountryAlpha2::Bahrain,
            CountryAlpha2::Bangladesh,
            CountryAlpha2::Barbados,
            CountryAlpha2::Belgium,
            CountryAlpha2::Belize,
            CountryAlpha2::Benin,
            CountryAlpha2::Bolivia,
            CountryAlpha2::Botswana,
            CountryAlpha2::Brazil,
            CountryAlpha2::Brunei_Darussalam,
            CountryAlpha2::Bulgaria,
            CountryAlpha2::Burkina_Faso,
            CountryAlpha2::Burundi,
            CountryAlpha2::Cabo_Verde,
            CountryAlpha2::Cambodia,
            CountryAlpha2::Cameroon,
            CountryAlpha2::Canada,
            CountryAlpha2::Central_African_Republic,
            CountryAlpha2::Chad,
            CountryAlpha2::Chile,
            CountryAlpha2::China,
            CountryAlpha2::Colombia,
            CountryAlpha2::Comoros,
            CountryAlpha2::Congo,
            CountryAlpha2::Congo_Democratic_Republic,
            CountryAlpha2::Costa_Rica,
            CountryAlpha2::Cote_d_Ivoire,
            CountryAlpha2::Croatia,
            CountryAlpha2::Cuba,
            CountryAlpha2::Cyprus,
            CountryAlpha2::Czechia,
            CountryAlpha2::Denmark,
            CountryAlpha2::Djibouti,
            CountryAlpha2::Dominica,
            CountryAlpha2::Dominican_Republic,
            CountryAlpha2::Ecuador,
            CountryAlpha2::Egypt,
            CountryAlpha2::El_Salvador,
            CountryAlpha2::Estonia,
            CountryAlpha2::Eswatini,
            CountryAlpha2::Fiji,
            CountryAlpha2::Finland,
            CountryAlpha2::France,
            CountryAlpha2::Gabon,
            CountryAlpha2::Gambia,
            CountryAlpha2::Georgia,
            CountryAlpha2::Germany,
            CountryAlpha2::Ghana,
            CountryAlpha2::Greece,
            CountryAlpha2::Grenada,
            CountryAlpha2::Guatemala,
            CountryAlpha2::Guinea,
            CountryAlpha2::Guinea_Bissau,
            CountryAlpha2::Guyana,
            CountryAlpha2::Haiti,
            CountryAlpha2::Honduras,
            CountryAlpha2::Hong_Kong,
            CountryAlpha2::Hungary,
            CountryAlpha2::Iceland,
            CountryAlpha2::India,
            CountryAlpha2::Indonesia,
            CountryAlpha2::Ireland,
            CountryAlpha2::Israel,
            CountryAlpha2::Italy,
            CountryAlpha2::Jamaica,
            CountryAlpha2::Japan,
            CountryAlpha2::Jordan,
            CountryAlpha2::Kazakhstan,
            CountryAlpha2::Kenya,
            CountryAlpha2::Korea_Republic,
            CountryAlpha2::Kuwait,
            CountryAlpha2::Kyrgyzstan,
            CountryAlpha2::Lao_Peoples_Democratic_Republic,
            CountryAlpha2::Latvia,
            CountryAlpha2::Lesotho,
            CountryAlpha2::Liberia,
            CountryAlpha2::Liechtenstein,
            CountryAlpha2::Lithuania,
            CountryAlpha2::Luxembourg,
            CountryAlpha2::Macao,
            CountryAlpha2::Madagascar,
            CountryAlpha2::Malawi,
            CountryAlpha2::Malaysia,
            CountryAlpha2::Maldives,
            CountryAlpha2::Mali,
            CountryAlpha2::Malta,
            CountryAlpha2::Mauritania,
            CountryAlpha2::Mauritius,
            CountryAlpha2::Mexico,
            CountryAlpha2::Moldova,
            CountryAlpha2::Mongolia,
            CountryAlpha2::Montenegro,
            CountryAlpha2::Morocco,
            CountryAlpha2::Mozambique,
            CountryAlpha2::Myanmar,
            CountryAlpha2::Namibia,
            CountryAlpha2::Nepal,
            CountryAlpha2::Netherlands,
            CountryAlpha2::New_Zealand,
            CountryAlpha2::Nicaragua,
            CountryAlpha2::Niger,
            CountryAlpha2::Nigeria,
            CountryAlpha2::North_Macedonia,
            CountryAlpha2::Norway,
            CountryAlpha2::Oman,
            CountryAlpha2::Pakistan,
            CountryAlpha2::Panama,
            CountryAlpha2::Papua_New_Guinea,
            CountryAlpha2::Paraguay,
            CountryAlpha2::Peru,
            CountryAlpha2::Philippines,
            CountryAlpha2::Poland,
            CountryAlpha2::Portugal,
            CountryAlpha2::Qatar,
            CountryAlpha2::Romania,
            CountryAlpha2::Russian_Federation,
            CountryAlpha2::Rwanda,
            CountryAlpha2::Saint_Kitts_and_Nevis,
            CountryAlpha2::Saint_Lucia,
            CountryAlpha2::Saint_Vincent_and_the_Grenadines,
            CountryAlpha2::Samoa,
            CountryAlpha2::Saudi_Arabia,
            CountryAlpha2::Senegal,
            CountryAlpha2::Seychelles,
            CountryAlpha2::Sierra_Leone,
            CountryAlpha2::Singapore,
            CountryAlpha2::Slovakia,
            CountryAlpha2::Slovenia,
            CountryAlpha2::Solomon_Islands,
            CountryAlpha2::South_Africa,
            CountryAlpha2::Spain,
            CountryAlpha2::Sri_Lanka,
            CountryAlpha2::Suriname,
            CountryAlpha2::Sweden,
            CountryAlpha2::Switzerland,
            CountryAlpha2::Taiwan_Province_of_China,
            CountryAlpha2::Tajikistan,
            CountryAlpha2::Tanzania,
            CountryAlpha2::Thailand,
            CountryAlpha2::Timor_Leste,
            CountryAlpha2::Togo,
            CountryAlpha2::Tonga,
            CountryAlpha2::Trinidad_and_Tobago,
            CountryAlpha2::Tunisia,
            CountryAlpha2::Turkey,
            CountryAlpha2::Uganda,
            CountryAlpha2::Ukraine,
            CountryAlpha2::United_Arab_Emirates,
            CountryAlpha2::United_Kingdom,
            CountryAlpha2::United_States_of_America,
            CountryAlpha2::Uruguay,
            CountryAlpha2::Vanuatu,
            CountryAlpha2::Venezuela,
            CountryAlpha2::Viet_Nam,
            CountryAlpha2::Yemen,
            CountryAlpha2::Zambia,
            CountryAlpha2::Zimbabwe,
        ];
    }
}
