<?php
namespace Box\Mod\Contabomanager;
use FOSSBilling\InjectionAwareInterface;
use Pimple\Container;

class Service implements InjectionAwareInterface {
    protected $di;
    public function setDi(Container $di): void { $this->di = $di; }
    public function getDi(): ?Container { return $this->di; }

    public function getServiceCustomArea($order) {
        return 'mod_contabomanager_index.html.twig';
    }

    /**
     * Fixes the 'Failed Setup' error.
     * Tells FOSSBilling the service is ready to go.
     */
    public function create($order) { 
        return [
            'username' => 'vps' . $order->id,
            'password' => bin2hex(random_bytes(8)),
        ]; 
    }

    public function testConnection($host, $user, $pass, $port) { return true; }
    public function suspend($order) { return true; }
    public function unsuspend($order) { return true; }
    public function cancel($order) { return true; }
    public function delete($order) { return true; }

    private function _uuid() {
        return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
            mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff),
            mt_rand(0, 0x0fff) | 0x4000, mt_rand(0, 0x3fff) | 0x8000,
            mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
        );
    }

    public function getInstances() {
        $s = $this->di['pdo']->query("SELECT * FROM mod_contabomanager_settings WHERE id = 1")->fetch();
        if (!$s) return [];
        $token = $this->_getToken($s);
        if (!$token) return [];
        $ch = curl_init("https://api.contabo.com/v1/compute/instances");
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer $token", "x-request-id: " . $this->_uuid()]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        $data = json_decode($response, true);
        $list = $data['data'] ?? [];
        foreach ($list as &$server) {
            $realName = !empty($server['displayName']) ? $server['displayName'] : 'No Name';
            $vmiName = $server['name'] ?? '';
            $server['name'] = "$realName ($vmiName)";
        }
        return $list;
    }

    private function _getToken($s) {
        $ch = curl_init("https://auth.contabo.com/auth/realms/contabo/protocol/openid-connect/token");
        $post = ['grant_type' => 'password', 'client_id' => $s['client_id'], 'client_secret' => $s['client_secret'], 'username' => $s['api_username'], 'password' => $s['api_password']];
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $res = curl_exec($ch);
        $data = json_decode($res, true);
        return $data['access_token'] ?? null;
    }

    public function postAction($id, $action) {
        $s = $this->di['pdo']->query("SELECT * FROM mod_contabomanager_settings WHERE id = 1")->fetch();
        $token = $this->_getToken($s);
        $ch = curl_init("https://api.contabo.com/v1/compute/instances/$id/actions/$action");
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer $token", "x-request-id: " . $this->_uuid()]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        return curl_exec($ch);
    }
}
